/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.PollingObjectAnalysis;
import ibm.nways.analysis.dpCommon.SingleNodeResourceAnalysis;
import ibm.nways.analysis.dpCommon.ThresholdAnalysis;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.HistogramPanel;
import ibm.nways.nhm.eui.ThresholdAnalyzer;
import java.awt.Event;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCListEvent;
import jclass.bwt.JCListListener;
import jclass.bwt.JCMultiColumnList;

public class SingleNodeAnalysisPanel
extends Panel
implements ActionListener,
JCListListener {
    private static final char DELIM = '|';
    private SingleNodeResourceAnalysis snra;
    private JCMultiColumnList overallTable;
    private JCMultiColumnList weekdayTable;
    private Label weekdayLabel;
    private Label hgramLabel;
    private PopupMenu popup;
    private MenuItem miThresh;
    private String selectionName;
    private String indexString;
    private ThresholdAnalyzer threshAnalyzer;
    private HistogramPanel hPanel;
    private NumberFormat pf;
    private FieldPosition fp;
    private String hostname;
    private long startTime;
    private long endTime;
    private ResourceBundle res = ResourceBundle.getBundle("ibm.nways.nhm.eui.AnalysisPanelResources");
    private String[] headings = new String[9];
    private int numOfRows = 10;

    public SingleNodeAnalysisPanel(ThresholdAnalyzer thresholdAnalyzer) {
        this.threshAnalyzer = thresholdAnalyzer;
        this.initialize();
        this.initPopupMenu();
    }

    public SingleNodeAnalysisPanel(ThresholdAnalyzer thresholdAnalyzer, SingleNodeResourceAnalysis singleNodeResourceAnalysis) {
        this.numOfRows = singleNodeResourceAnalysis.objects.length;
        this.threshAnalyzer = thresholdAnalyzer;
        this.initialize();
        this.pf = NumberFormat.getPercentInstance();
        this.pf.setMaximumFractionDigits(1);
        this.fp = new FieldPosition(1);
        this.setData(singleNodeResourceAnalysis);
        this.initPopupMenu();
    }

    public void setData(SingleNodeResourceAnalysis singleNodeResourceAnalysis) {
        PollingObjectAnalysis pollingObjectAnalysis;
        StringBuffer stringBuffer;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat.setTimeZone(TimeZone.getDefault());
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(4);
        int n = 0;
        while (n < singleNodeResourceAnalysis.objects.length) {
            stringBuffer = new StringBuffer(250);
            pollingObjectAnalysis = singleNodeResourceAnalysis.objects[n];
            if (pollingObjectAnalysis != null) {
                stringBuffer.append(pollingObjectAnalysis.identifier);
                stringBuffer.append('|');
                stringBuffer.append(pollingObjectAnalysis.instanceId);
                stringBuffer.append('|');
                numberFormat.format(pollingObjectAnalysis.overallMean, stringBuffer, this.fp);
                stringBuffer.append('|');
                numberFormat.format(pollingObjectAnalysis.overallSd, stringBuffer, this.fp);
                stringBuffer.append('|');
                if (pollingObjectAnalysis.thresholdOperator != null) {
                    stringBuffer.append(pollingObjectAnalysis.thresholdOperator);
                    stringBuffer.append(" ");
                }
                numberFormat.format(pollingObjectAnalysis.thresholdValue, stringBuffer, this.fp);
                stringBuffer.append('|');
                numberFormat.format(pollingObjectAnalysis.overallHighWaterMark, stringBuffer, this.fp);
                stringBuffer.append('|');
                if (pollingObjectAnalysis.overallHighWaterTime != -1L) {
                    dateFormat.format(new Date(pollingObjectAnalysis.overallHighWaterTime), stringBuffer, this.fp);
                }
                stringBuffer.append('|');
                if (pollingObjectAnalysis.overallLowWaterMark != -1.0f) {
                    numberFormat.format(pollingObjectAnalysis.overallLowWaterMark, stringBuffer, this.fp);
                }
                stringBuffer.append('|');
                dateFormat.format(new Date(pollingObjectAnalysis.overallLowWaterTime), stringBuffer, this.fp);
                stringBuffer.append('|');
                this.overallTable.addItem(stringBuffer.toString(), '|');
            }
            ++n;
        }
        if (singleNodeResourceAnalysis.objects.length > 0 && singleNodeResourceAnalysis.objects[0].weekdayN > 0) {
            n = 0;
            while (n < singleNodeResourceAnalysis.objects.length) {
                stringBuffer = new StringBuffer(250);
                pollingObjectAnalysis = singleNodeResourceAnalysis.objects[n];
                if (pollingObjectAnalysis != null) {
                    stringBuffer.append(pollingObjectAnalysis.identifier);
                    stringBuffer.append('|');
                    stringBuffer.append(pollingObjectAnalysis.instanceId);
                    stringBuffer.append('|');
                    numberFormat.format(pollingObjectAnalysis.weekdayMean, stringBuffer, this.fp);
                    stringBuffer.append('|');
                    numberFormat.format(pollingObjectAnalysis.weekdaySd, stringBuffer, this.fp);
                    stringBuffer.append('|');
                    if (pollingObjectAnalysis.thresholdOperator != null) {
                        stringBuffer.append(pollingObjectAnalysis.thresholdOperator);
                        stringBuffer.append(" ");
                    }
                    numberFormat.format(pollingObjectAnalysis.thresholdValue, stringBuffer, this.fp);
                    stringBuffer.append('|');
                    numberFormat.format(pollingObjectAnalysis.weekdayHighWaterMark, stringBuffer, this.fp);
                    stringBuffer.append('|');
                    if (pollingObjectAnalysis.weekdayHighWaterTime != -1L) {
                        dateFormat.format(new Date(pollingObjectAnalysis.weekdayHighWaterTime), stringBuffer, this.fp);
                    }
                    stringBuffer.append('|');
                    if (pollingObjectAnalysis.weekdayHighWaterTime != -1L) {
                        numberFormat.format(pollingObjectAnalysis.weekdayLowWaterMark, stringBuffer, this.fp);
                    }
                    stringBuffer.append('|');
                    dateFormat.format(new Date(pollingObjectAnalysis.weekdayLowWaterTime), stringBuffer, this.fp);
                    this.weekdayTable.addItem(stringBuffer.toString(), '|');
                }
                ++n;
            }
            return;
        }
        this.weekdayLabel.setVisible(false);
        this.weekdayTable.setVisible(false);
        this.weekdayTable.removeItemListener(this);
    }

    public void initPopupMenu() {
        this.popup = new PopupMenu();
        this.miThresh = new MenuItem(this.res.getString("s_threshMenu"));
        this.miThresh.addActionListener(this);
        MenuItem menuItem = new MenuItem(this.res.getString("s_Quit"));
        this.popup.add(this.miThresh);
        this.popup.add(menuItem);
        this.add(this.popup);
    }

    public void initialize() {
        this.headings[0] = this.res.getString("s_Name");
        this.headings[1] = this.res.getString("s_Inst");
        this.headings[2] = this.res.getString("s_Mean");
        this.headings[3] = this.res.getString("s_Sd");
        this.headings[4] = this.res.getString("s_Thresh");
        this.headings[5] = this.res.getString("s_hw");
        this.headings[6] = this.res.getString("s_hwt");
        this.headings[7] = this.res.getString("s_lw");
        this.headings[8] = this.res.getString("s_lwt");
        this.setLayout(new ColumnLayout());
        this.overallTable = new JCMultiColumnList(this.numOfRows, false);
        this.overallTable.setColumnButtons(this.headings);
        this.add(new Label(String.valueOf(this.res.getString("s_24")) + "  " + this.threshAnalyzer.getTimeRangeString()));
        this.add(this.overallTable);
        this.weekdayTable = new JCMultiColumnList(this.numOfRows, false);
        this.weekdayTable.setColumnButtons(this.headings);
        this.weekdayLabel = new Label(this.res.getString("s_Weekday"));
        this.add(this.weekdayLabel);
        this.add(this.weekdayTable);
        this.hPanel = new HistogramPanel();
        this.add(new Label(this.res.getString("s_AHgram")));
        this.hgramLabel = new Label(" ");
        this.add(this.hgramLabel);
        this.add(this.hPanel);
        this.overallTable.addItemListener(this);
        this.weekdayTable.addItemListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.miThresh) {
            String string = new String(this.selectionName);
            if (this.indexString != null) {
                string = String.valueOf(string) + "." + this.indexString;
            }
            if (this.hPanel.alreadyExists(string)) {
                this.hPanel.showChart(string);
                return;
            }
            ThresholdAnalysis thresholdAnalysis = this.threshAnalyzer.getThresholdAnalysis(this.selectionName, this.indexString);
            this.hPanel.addChart(thresholdAnalysis);
            StringBuffer stringBuffer = new StringBuffer(45);
            stringBuffer.append(this.res.getString("s_hgLabel1"));
            stringBuffer.append(thresholdAnalysis.getId());
            stringBuffer.append(this.res.getString("s_hgLabel2"));
            this.pf.format(thresholdAnalysis.percentThresholdArmed, stringBuffer, this.fp);
            stringBuffer.append(this.res.getString("s_hgLabel3"));
            this.validate();
        }
    }

    public void listItemSelectEnd(JCListEvent jCListEvent) {
        JCMultiColumnList jCMultiColumnList = null;
        if (jCListEvent.getSource() == this.overallTable) {
            jCMultiColumnList = this.overallTable;
        } else if (jCListEvent.getSource() == this.weekdayTable) {
            jCMultiColumnList = this.weekdayTable;
        }
        Event event = jCListEvent.getSourceEvent();
        if (event.id == 501) {
            Vector vector;
            System.out.println("Mouse event received");
            if (jCMultiColumnList != null && (vector = (Vector)jCMultiColumnList.getSelectedItem()) != null) {
                this.popup.show(jCMultiColumnList, event.x, event.y + 10);
                this.selectionName = (String)vector.elementAt(0);
                this.indexString = (String)vector.elementAt(1);
            }
        }
    }

    public void listItemSelectBegin(JCListEvent jCListEvent) {
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
    }
}

